/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.mccs;

import com.quantumdata.mccs.CommonPanel;
import com.quantumdata.mccs.Constants;
import com.quantumdata.mccs.JTextFieldLimit;
import com.quantumdata.mccs.MCCSGUIFrame;
import com.quantumdata.mccs.MySlider;
import com.quantumdata.mccs.VCPCodes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class AudioPanel
extends CommonPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final int SPEAKER_VOLUME = 0;
    private final int SPEAKER_SELECT = 1;
    private final int AUDIO_MUTE = 2;
    private final int AUDIO_TREBLE = 3;
    private final int AUDIO_BASS = 4;
    private final int AUDIO_BALANCE = 5;
    private final int AUDIO_PROCESSOR_MODE = 6;
    private JTextField jTextSpeakerVolVal;
    private JButton jSetSpeakerVolButton;
    private JComboBox jComboSpeakerSelect;
    private JButton jSetSpeakerSelectButton;
    private JCheckBox jCheckAudioMute;
    private JButton jSetAudioMuteButton;
    private JTextField jTextAudioTrebleVal;
    private JButton jSetAudioTrebleButton;
    private JTextField jTextAudioBassVal;
    private JButton jSetAudioBassButton;
    private JTextField jTextAudioBalanceVal;
    private JButton jSetAudioBalanceButton;
    private JComboBox jComboAudioProcessorMode;
    private JButton jSetAudioProcessorModeButton;

    public AudioPanel() {
        super(7, 1);
        this.addSpeakerVolume();
        this.addSpeakerSelect();
        this.addMicrophoneVolume();
        this.addAudioMute();
        this.addAudioTreble();
        this.addAudioBass();
        this.addAudioBalance();
        this.addAudioProcessorMode();
        this.constructPanel();
    }

    private void addSpeakerVolume() {
        this.vcpCodes[0] = new VCPCodes("Audio: Speaker Volume", "62", "R/W", "NC");
        this.jTextSpeakerVolVal = Constants.createFieldValueText(true);
        this.jTextSpeakerVolVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 2));
        this.jTextSpeakerVolVal.setText("00");
        this.jSetSpeakerVolButton = Constants.createSetButton(this);
    }

    private void addSpeakerSelect() {
        this.vcpCodes[1] = new VCPCodes("Speaker Select", "63", "R/W", "NC", 5);
        this.vcpCodes[1].setValueDetails(0, "00", "Front L/R");
        this.vcpCodes[1].setValueDetails(1, "01", "Side L/R");
        this.vcpCodes[1].setValueDetails(2, "02", "Rear L/R");
        this.vcpCodes[1].setValueDetails(3, "03", "Center / Sub woofer");
        this.vcpCodes[1].setValueDetails(4, "", "Reserved");
        this.vcpCodes[1].setValueForReserved(4);
        this.jComboSpeakerSelect = new JComboBox();
        this.jComboSpeakerSelect.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[1])));
        this.jSetSpeakerSelectButton = Constants.createSetButton(this);
    }

    private void addMicrophoneVolume() {
        this.mySliders[0] = new MySlider("Audio: Microphone Volume", "64");
    }

    private void addAudioMute() {
        this.vcpCodes[2] = new VCPCodes("Audio Mute", "8D", "R/W", "NC");
        this.jCheckAudioMute = Constants.createCheckbox("Mute / Unmute", this);
        this.jSetAudioMuteButton = Constants.createSetButton(this);
    }

    private void addAudioTreble() {
        this.vcpCodes[3] = new VCPCodes("Audio Treble", "8F", "R/W", "NC");
        this.jTextAudioTrebleVal = Constants.createFieldValueText(true);
        this.jTextAudioTrebleVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 2));
        this.jTextAudioTrebleVal.setText("01");
        this.jSetAudioTrebleButton = Constants.createSetButton(this);
    }

    private void addAudioBass() {
        this.vcpCodes[4] = new VCPCodes("Audio Bass", "91", "R/W", "NC");
        this.jTextAudioBassVal = Constants.createFieldValueText(true);
        this.jTextAudioBassVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 2));
        this.jTextAudioBassVal.setText("01");
        this.jSetAudioBassButton = Constants.createSetButton(this);
    }

    private void addAudioBalance() {
        this.vcpCodes[5] = new VCPCodes("Audio Balance", "93", "R/W", "NC");
        this.jTextAudioBalanceVal = Constants.createFieldValueText(true);
        this.jTextAudioBalanceVal.setDocument(new JTextFieldLimit("0123456789ABCDEFabcdef", 2));
        this.jTextAudioBalanceVal.setText("01");
        this.jSetAudioBalanceButton = Constants.createSetButton(this);
    }

    private void addAudioProcessorMode() {
        this.vcpCodes[6] = new VCPCodes("Audio Processor Mode", "94", "R/W", "NC", 26);
        this.vcpCodes[6].setValueDetails(0, "00", "Audio processing is not supported");
        this.vcpCodes[6].setValueDetails(1, "01", "Mono (Both display audio channels use the left audio channel)");
        this.vcpCodes[6].setValueDetails(2, "02", "Stereo (Incoming left and right audio channels feed separate display)");
        this.vcpCodes[6].setValueDetails(3, "03", "Stereo expanded (As defined by the manufacturer)");
        this.vcpCodes[6].setValueDetails(4, "11", "SRS 2.0 (SRS stereo)");
        this.vcpCodes[6].setValueDetails(5, "12", "SRS 2.1 (SRS stereo + subwoofer)");
        this.vcpCodes[6].setValueDetails(6, "13", "SRS 3.1 (SRS stereo + subwoofer + center)");
        this.vcpCodes[6].setValueDetails(7, "14", "SRS 4.1 (SRS stereo + subwoofer + rear)");
        this.vcpCodes[6].setValueDetails(8, "15", "SRS 5.0 (SRS stereo + subwoofer + rear + center)");
        this.vcpCodes[6].setValueDetails(9, "16", "SRS 6.1 (SRS stereo + subwoofer + side)");
        this.vcpCodes[6].setValueDetails(10, "17", "SRS 7.0 (SRS stereo + subwoofer + side + center)");
        this.vcpCodes[6].setValueDetails(11, "21", "Dolby 2.0 (Dolby stereo)");
        this.vcpCodes[6].setValueDetails(12, "22", "Dolby 2.1 (Dolby stereo + subwoofer)");
        this.vcpCodes[6].setValueDetails(13, "23", "Dolby 3.1 (Dolby stereo + subwoofer + center)");
        this.vcpCodes[6].setValueDetails(14, "24", "Dolby 4.1 (Dolby stereo + subwoofer + rear)");
        this.vcpCodes[6].setValueDetails(15, "25", "Dolby 5.0 (Dolby stereo + subwoofer + rear + center)");
        this.vcpCodes[6].setValueDetails(16, "26", "Dolby 6.1 (Dolby stereo + subwoofer + side)");
        this.vcpCodes[6].setValueDetails(17, "27", "Dolby 7.0 (Dolby stereo + subwoofer + side + center)");
        this.vcpCodes[6].setValueDetails(18, "31", "THX 2.0 (THX stereo)");
        this.vcpCodes[6].setValueDetails(19, "32", "THX 2.1 (THX stereo + subwoofer)");
        this.vcpCodes[6].setValueDetails(20, "33", "THX 3.1 (THX stereo + subwoofer + center)");
        this.vcpCodes[6].setValueDetails(21, "34", "THX 4.1 (THX stereo + subwoofer + rear)");
        this.vcpCodes[6].setValueDetails(22, "35", "THX 5.0 (THX stereo + subwoofer + rear + center)");
        this.vcpCodes[6].setValueDetails(23, "36", "THX 6.1 (THX stereo + subwoofer + side)");
        this.vcpCodes[6].setValueDetails(24, "37", "THX 7.0 (THX stereo + subwoofer + side + center)");
        this.vcpCodes[6].setValueDetails(25, "", "Reserved");
        this.vcpCodes[6].setValueForReserved(25);
        this.jComboAudioProcessorMode = new JComboBox();
        this.jComboAudioProcessorMode.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[6])));
        this.jSetAudioProcessorModeButton = Constants.createSetButton(this);
    }

    private void constructPanel() {
        this.layout.setHorizontalGroup(this.layout.createParallelGroup(1).add(this.layout.createSequentialGroup().add(36, 36, 36).add(this.layout.createParallelGroup(1).add(this.vcpCodes[0].getNameField(), -2, -1, -2).add(this.vcpCodes[1].getNameField(), -2, -1, -2).add(this.mySliders[0].getNameField(), -2, -1, -2).add(this.vcpCodes[2].getNameField(), -2, -1, -2).add(this.vcpCodes[3].getNameField(), -2, -1, -2).add(this.vcpCodes[4].getNameField(), -2, -1, -2).add(this.vcpCodes[5].getNameField(), -2, -1, -2).add(this.vcpCodes[6].getNameField(), -2, -1, -2)).add(23, 23, 23).add(this.layout.createParallelGroup(1).add(this.layout.createSequentialGroup().add(this.layout.createParallelGroup(1).add(this.jTextSpeakerVolVal, -2, 30, -2).add(this.jTextAudioTrebleVal, -2, 30, -2).add(this.jTextAudioBassVal, -2, 30, -2).add(this.jTextAudioBalanceVal, -2, 30, -2)).add(23, 23, 23).add(this.layout.createParallelGroup(1).add(this.jSetAudioTrebleButton).add(this.jSetAudioBassButton).add(this.jSetAudioBalanceButton).add(this.jSetSpeakerVolButton))).add(this.layout.createSequentialGroup().add(this.jComboSpeakerSelect, -2, -1, -2).add(23, 23, 23).add(this.jSetSpeakerSelectButton)).add(this.layout.createSequentialGroup().add(this.jCheckAudioMute).add(23, 23, 23).add(this.jSetAudioMuteButton)).add(this.layout.createSequentialGroup().add(this.jComboAudioProcessorMode, -2, -1, -2).add(23, 23, 23).add(this.jSetAudioProcessorModeButton)).add(this.layout.createSequentialGroup().add(this.mySliders[0].getSliderValField(), -2, 40, -2).addPreferredGap(0).add(this.mySliders[0].getThisSlider(), -1, 880, Short.MAX_VALUE))).addContainerGap(54, Short.MAX_VALUE)));
        this.layout.setVerticalGroup(this.layout.createParallelGroup(1).add(this.layout.createSequentialGroup().add(36, 36, 36).add(this.layout.createParallelGroup(3).add(this.vcpCodes[0].getNameField(), -2, -1, -2).add(this.jTextSpeakerVolVal, -2, 28, -2).add(this.jSetSpeakerVolButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[1].getNameField(), -2, -1, -2).add(this.jSetSpeakerSelectButton, -2, 20, -2).add(this.jComboSpeakerSelect, -2, 28, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(1).add(this.layout.createParallelGroup(3).add(this.mySliders[0].getNameField(), -2, -1, -2).add(this.mySliders[0].getSliderValField(), -2, -1, -2)).add(this.mySliders[0].getThisSlider(), -2, -1, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[2].getNameField(), -2, -1, -2).add(this.jCheckAudioMute).add(this.jSetAudioMuteButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[3].getNameField(), -2, -1, -2).add(this.jTextAudioTrebleVal, -2, 28, -2).add(this.jSetAudioTrebleButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[4].getNameField(), -2, -1, -2).add(this.jTextAudioBassVal, -2, 28, -2).add(this.jSetAudioBassButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[5].getNameField(), -2, -1, -2).add(this.jTextAudioBalanceVal, -2, 28, -2).add(this.jSetAudioBalanceButton, -2, 20, -2)).add(15, 15, 15).add(this.layout.createParallelGroup(3).add(this.vcpCodes[6].getNameField(), -2, -1, -2).add(this.jComboAudioProcessorMode, -2, 28, -2).add(this.jSetAudioProcessorModeButton, -2, 20, -2)).addContainerGap(61, Short.MAX_VALUE)));
    }

    public String getVcpDetails(String string) {
        return string;
    }

    public void getAllValues(boolean bl, boolean bl2) {
        if (MCCSGUIFrame.allConnected(bl)) {
            this.getSpeakerVolume(bl2);
            this.getSpeakerSelect(bl2);
            this.mySliders[0].getSliderVal(bl2);
            this.getAudioMute(bl2);
            this.getAudioTreble(bl2);
            this.getAudioBass(bl2);
            this.getAudioBalance(bl2);
            this.getAudioProcessorMode(bl2);
            this.revalidate();
        }
    }

    public void refreshPanelContents() {
        boolean bl = this.vcpCodes[0].isSupported();
        this.jTextSpeakerVolVal.setEnabled(bl);
        this.jSetSpeakerVolButton.setEnabled(bl);
        bl = this.vcpCodes[1].isSupported();
        this.jComboSpeakerSelect.setEnabled(bl);
        this.jSetSpeakerSelectButton.setEnabled(bl);
        if (bl) {
            this.jComboSpeakerSelect.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[1])));
        }
        bl = this.vcpCodes[2].isSupported();
        this.jCheckAudioMute.setEnabled(bl);
        this.jSetAudioMuteButton.setEnabled(bl);
        bl = this.vcpCodes[3].isSupported();
        this.jTextAudioTrebleVal.setEnabled(bl);
        this.jSetAudioTrebleButton.setEnabled(bl);
        bl = this.vcpCodes[4].isSupported();
        this.jTextAudioBassVal.setEnabled(bl);
        this.jSetAudioBassButton.setEnabled(bl);
        bl = this.vcpCodes[5].isSupported();
        this.jTextAudioBalanceVal.setEnabled(bl);
        this.jSetAudioBalanceButton.setEnabled(bl);
        bl = this.vcpCodes[6].isSupported();
        this.jComboAudioProcessorMode.setEnabled(bl);
        this.jSetAudioProcessorModeButton.setEnabled(bl);
        if (bl) {
            this.jComboAudioProcessorMode.setModel(new DefaultComboBoxModel<String>(Constants.getComboStringArray(this.vcpCodes[6])));
        }
    }

    private void getSpeakerVolume(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[0], bl) != 0) {
            this.jTextSpeakerVolVal.setText(Integer.toHexString(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void setSpeakerVolume() {
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[0], this.jTextSpeakerVolVal.getText());
    }

    private void getSpeakerSelect(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[1], bl) != 0) {
            this.jComboSpeakerSelect.setSelectedItem(this.vcpCodes[1].getDetailByCmdValue(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void setSpeakerSelect() {
        MCCSGUIFrame.writeToDisplay((String)this.jComboSpeakerSelect.getSelectedItem(), this.vcpCodes[1]);
    }

    private void getAudioMute(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[2], bl) != 0) {
            if (MCCSGUIFrame.getReadRespSL() == 1) {
                this.jCheckAudioMute.setSelected(true);
            } else {
                this.jCheckAudioMute.setSelected(false);
            }
        }
    }

    private void setAudioMute() {
        if (this.jCheckAudioMute.isSelected()) {
            MCCSGUIFrame.writeToDisplay(this.vcpCodes[2], 1);
        } else {
            MCCSGUIFrame.writeToDisplay(this.vcpCodes[2], 2);
        }
    }

    private void getAudioTreble(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[3], bl) != 0) {
            this.jTextAudioTrebleVal.setText(Integer.toHexString(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void setAudioTreble() {
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[3], this.jTextAudioTrebleVal.getText());
    }

    private void getAudioBass(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[4], bl) != 0) {
            this.jTextAudioBassVal.setText(Integer.toHexString(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void setAudioBass() {
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[4], this.jTextAudioBassVal.getText());
    }

    private void getAudioBalance(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[5], bl) != 0) {
            this.jTextAudioBalanceVal.setText(Integer.toHexString(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void setAudioBalance() {
        MCCSGUIFrame.writeToDisplay(this.vcpCodes[5], this.jTextAudioBalanceVal.getText());
    }

    private void getAudioProcessorMode(boolean bl) {
        if (MCCSGUIFrame.readFromDisplay(this.vcpCodes[6], bl) != 0) {
            this.jComboAudioProcessorMode.setSelectedItem(this.vcpCodes[6].getDetailByCmdValue(MCCSGUIFrame.getReadRespSL()));
        }
    }

    private void setAudioProcessorMode() {
        MCCSGUIFrame.writeToDisplay((String)this.jComboAudioProcessorMode.getSelectedItem(), this.vcpCodes[6]);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (MCCSGUIFrame.allConnected(true)) {
            if (object == this.jSetSpeakerVolButton) {
                this.setSpeakerVolume();
            } else if (object == this.jSetSpeakerSelectButton) {
                this.setSpeakerSelect();
            } else if (object == this.jSetAudioMuteButton) {
                this.setAudioMute();
            } else if (object == this.jSetAudioTrebleButton) {
                this.setAudioTreble();
            } else if (object == this.jSetAudioBassButton) {
                this.setAudioBass();
            } else if (object == this.jSetAudioBalanceButton) {
                this.setAudioBalance();
            } else if (object == this.jSetAudioProcessorModeButton) {
                this.setAudioProcessorMode();
            }
        }
    }
}

